<!DOCTYPE html>
<html lang="en"><head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <title></title>
    <link rel="stylesheet" href="include/css/base.css">
    <link rel="stylesheet" href="include/css/stylesheet.css">

    <style>
        label    { width: 5em; vertical-align: top; }
        input    { max-width: 62em; font-size:16pt; }
        textarea { max-width: 62em; }
        .production span { background-color: #ffff66; }
        .production a { font-style: italic; }
    </style>
    <script src="include/js/sha-256.js"></script>
    <script>
        'use strict';
        var doc       = document;
				doc.qrySel    = doc.querySelector;
				doc.qrySelAll = doc.querySelectorAll;                                 // shorthand
        document.addEventListener('DOMContentLoaded', function(event) {       // toUpperCase(&nbsp;)
            doc.qrySel('#message').oninput = function() {
               var hash = Sha256.hash(this.value);
               doc.qrySel('#digest').value = hash.toUpperCase();
                                                                              /* doc.qrySel('#time').value = (t2-t1).toFixed(3)+'ms';*/
                var Lhash=hash;
                doc.qrySel('#hash_lenth').value = (Lhash.toString()).length;
            };
            doc.qrySel('#message').focus();
            doc.qrySel('#message').select();
            doc.qrySel('#message').oninput();                                 // initial hash call
        });
    </script>
</head>

<body>

<form name="f">
  <fieldset>
  <legend>Enter any message to check its SHA-256 hash</legend>
  <ul>
    <li>
      <label for="message">Message</label>
      <textarea name="message" id="message" class="width-full">0</textarea>
    </li>
    <li>
      <label for="digest">Hash</label>
      <input name="digest" id="digest"  class="width-full" value="" type="text">
      <input name="dipest" id="dipest" readonly="readonly" class="width-full" value="1234567890123456789012345678901234567890123456789012345678901234" type="text">
      <input name="difest" id="difest" readonly="readonly" class="width-full" value="0________1_________2_________3_________4_________5_________6____" type="text">
      <output class="small grey" id="time">0.080ms</output>
      <br />
      <output class="grey" id = "hash_lenth">0</output> 
    </li>
    <li><small>
		           <i>Note SHA-256 hash of ‘abc’ should be:
                  ba7816bf­8f01cfea­414140de­5dae2223­b00361a3­96177a9c­b410ff61­f20015ad
				       </i>
				</small>
		</li>
  </ul>
  </fieldset>
</form>



</body></html>
